<?php
// Test script for the deployed Appwrite Web Search function

// Configuration
$baseUrl = 'https://695d4dcd003509e0831e.fra.appwrite.run'; // Your deployed function URL

echo "Testing Deployed Appwrite Web Search Function\n";
echo "=============================================\n\n";

// Test 1: Basic search functionality
echo "Test 1: Basic Search\n";
echo "-------------------\n";
$searchUrl = $baseUrl . '?' . http_build_query([
    'action' => 'search',
    'q' => 'PHP programming',
    'limit' => 2
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $searchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60); // Increased timeout for web operations
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // In case of SSL issues

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "cURL Error: $error\n\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response (first 300 chars):\n";
        echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 300) . "...\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }
    echo "\n";
}

// Test 2: Visit a webpage
echo "Test 2: Visit Webpage\n";
echo "--------------------\n";
$visitUrl = $baseUrl . '?' . http_build_query([
    'action' => 'visit',
    'url' => 'https://httpbin.org/html'
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $visitUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "cURL Error: $error\n\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response (first 300 chars):\n";
        echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 300) . "...\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }
    echo "\n";
}

// Test 3: Advanced scraping with selectors
echo "Test 3: Advanced Scraping with Selectors\n";
echo "----------------------------------------\n";
$scrapeUrl = $baseUrl . '?' . http_build_query([
    'action' => 'scrape',
    'url' => 'https://httpbin.org/html',
    'selectors' => json_encode(['title' => 'h1', 'paragraphs' => 'p'])
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $scrapeUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "cURL Error: $error\n\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response (first 300 chars):\n";
        echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 300) . "...\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }
    echo "\n";
}

// Test 4: POST request
echo "Test 4: POST Request\n";
echo "-------------------\n";

$postData = [
    'action' => 'search',
    'q' => 'web scraping',
    'limit' => 1
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $baseUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 300 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 300) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}

echo "\nTests completed. Check the results above.\n";