<?php
// Test script for the cleaned up WebSearchManager class

require_once 'web-search.php';

try {
    // Initialize the WebSearchManager
    echo "Initializing WebSearchManager...\n";
    $searchManager = new WebSearchManager();
    
    echo "Performing a test search...\n";
    $results = $searchManager->search("PHP programming", 3);
    
    echo "Search completed successfully!\n";
    echo "Success: " . ($results['success'] ? 'true' : 'false') . "\n";
    echo "Query: " . $results['query'] . "\n";
    echo "Number of results: " . count($results['results']) . "\n";
    
    if (count($results['results']) > 0) {
        echo "First result:\n";
        echo "  Title: " . $results['results'][0]['title'] . "\n";
        echo "  Link: " . $results['results'][0]['link'] . "\n";
        echo "  Snippet: " . substr($results['results'][0]['snippet'], 0, 100) . "...\n";
    }
    
    echo "\nClass has been cleaned up successfully - no mock data fallbacks remain!\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}