# Enhanced Web Search API Documentation

This API provides web search functionality, webpage visiting, screenshot taking, and advanced web scraping capabilities that external applications can call.

## Base URL
```
http://your-domain.com/ota/api/web-search/api.php
```

## Authentication
No authentication is required to use this API.

## Actions

The API supports different actions that can be specified using the `action` parameter:

### 1. Search (default)
Perform web search with content scraping.

#### Parameters
- `action` (optional): Set to "search" (default)
- `q` or `query` (required): The search query string
- `limit` (optional): Maximum number of results to return (1-20, default: 5)

#### Example Requests
```
GET /ota/api/web-search/api.php?action=search&q=technology+news&limit=5
```

```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "search", "q": "technology news", "limit": 5}'
```

### 2. Visit Page
Visit a webpage and return its content.

#### Parameters
- `action`: Set to "visit"
- `url` (required): The URL to visit

#### Example Requests
```
GET /ota/api/web-search/api.php?action=visit&url=https://example.com
```

```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "visit", "url": "https://example.com"}'
```

### 3. Take Screenshot
Take a screenshot of a webpage.

#### Parameters
- `action`: Set to "screenshot"
- `url` (required): The URL to take screenshot of

#### Example Requests
```
GET /ota/api/web-search/api.php?action=screenshot&url=https://example.com
```

```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "screenshot", "url": "https://example.com"}'
```

### 4. Scrape Webpage
Scrape content from a webpage, with optional custom selectors.

#### Parameters
- `action`: Set to "scrape"
- `url` (required): The URL to scrape
- `selectors` (optional): JSON object with custom CSS selectors for advanced scraping

#### Example Requests
Basic scraping:
```
GET /ota/api/web-search/api.php?action=scrape&url=https://example.com
```

Advanced scraping with custom selectors:
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "scrape", "url": "https://example.com", "selectors": {"title": "h1", "articles": ".article"}}'
```

### 5. Get Console Logs
Navigate to a webpage and retrieve browser console logs.

#### Parameters
- `action`: Set to "console_logs"
- `url` (required): The URL to navigate to

#### Example Requests
```
GET /ota/api/web-search/api.php?action=console_logs&url=https://example.com
```

```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "console_logs", "url": "https://example.com"}'
```

### 6. Execute JavaScript
Navigate to a webpage and execute custom JavaScript code.

#### Parameters
- `action`: Set to "execute_js"
- `url` (required): The URL to navigate to
- `javascript` (required): The JavaScript code to execute

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "execute_js", "url": "https://example.com", "javascript": "document.title"}'
```

### 7. Interact with Page Elements
Interact with webpage elements (click, fill forms, etc.).

#### Parameters
- `action`: Set to "interact"
- `url` (required): The URL to navigate to
- `interactions` (required): Array of interaction objects

Interaction object properties:
- `type`: Type of interaction ("click", "fill", "get_text")
- `selector`: CSS selector for the element
- `value`: Value to fill (for "fill" type)

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "interact", "url": "https://example.com", "interactions": [{"type": "click", "selector": "#submit-button"}, {"type": "get_text", "selector": "h1"}]}'
```

### 8. Get Performance Metrics
Get performance metrics for a webpage.

#### Parameters
- `action`: Set to "performance_metrics"
- `url` (required): The URL to analyze

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "performance_metrics", "url": "https://example.com"}'
```

### 9. Execute Multi-Step Workflows
Execute complex multi-step workflows.

#### Parameters
- `action`: Set to "workflow"
- `steps` (required): Array of steps to execute

Step object properties:
- `action`: Type of action ("navigate", "interact", "extract", "wait", "form_submit")
- `url`: URL for the action
- Other parameters specific to each action type

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "workflow", "steps": [{"action": "navigate", "url": "https://example.com"}, {"action": "interact", "url": "https://example.com", "interactions": [{"type": "click", "selector": "#button"}]}]}'
```

### 10. Submit Forms
Submit forms programmatically.

#### Parameters
- `action`: Set to "form_submit"
- `url` (required): The URL containing the form
- `form_data` (required): Object containing form field data
- `form_selector` (optional): CSS selector for the form (default: "form")

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "form_submit", "url": "https://example.com/contact", "form_data": {"name": "John Doe", "email": "john@example.com", "message": "Hello"}}'
```

### 11. Manage Cookies
Get, set, delete, or clear cookies.

#### Parameters
- `action`: Set to "cookies"
- `url` (required): The URL to manage cookies for
- `operation` (required): Operation to perform ("get", "set", "delete", "clear")
- `cookie_data` (required for "set" and "delete"): Cookie data

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "cookies", "url": "https://example.com", "operation": "get"}'
```

### 12. Login to Websites
Login to websites using username and password.

#### Parameters
- `action`: Set to "login"
- `url` (required): The login page URL
- `username` (required): The username
- `password` (required): The password
- `selectors` (optional): Custom selectors for login form fields

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "login", "url": "https://example.com/login", "username": "myuser", "password": "mypassword"}'
```

### 13. Wait for Conditions
Wait for specific conditions on a webpage.

#### Parameters
- `action`: Set to "wait_for"
- `url` (required): The URL to navigate to
- `conditions` (required): Array of conditions to wait for
- `timeout` (optional): Maximum time to wait in seconds (default: 10)

Condition object properties:
- `type`: Type of condition ("element_present", "element_visible", "text_present", "url_contains")
- `selector`: CSS selector for element conditions
- `text`: Text for text or URL conditions

#### Example Requests
```bash
curl -X POST http://your-domain.com/ota/api/web-search/api.php \
  -H "Content-Type: application/json" \
  -d '{"action": "wait_for", "url": "https://example.com", "conditions": [{"type": "element_present", "selector": "#loaded-content"}], "timeout": 15}'
```

## Response Format
The API returns JSON responses with the following structure:

```json
{
  "success": true,
  "query": "search query",
  "results": [
    {
      "title": "Result title",
      "link": "URL to the source",
      "snippet": "Brief description of the content",
      "content": "Full scraped content from the page",
      "html_content": "HTML content from the page",
      "footer_content": "Footer content from the page"
    }
  ],
  "timestamp": "2023-01-01 12:00:00"
}
```

## Error Responses
When an error occurs, the API returns an appropriate HTTP status code and a JSON error object:

```json
{
  "error": "Error message",
  "message": "Detailed error description"
}
```

## HTTP Status Codes
- `200`: Success
- `400`: Bad Request (invalid parameters)
- `401`: Unauthorized (missing or invalid API key)
- `405`: Method Not Allowed
- `500`: Internal Server Error

## Rate Limiting
There is no built-in rate limiting. Implement rate limiting at the server level as needed.

## Security Notes
- Change the default API key in the configuration
- Consider using HTTPS in production
- Implement additional security measures as needed for your use case